function plot_values(Y_T,T,eta,H_rad,rho_c,H_shearheat)

    figure(4); clf
        
    % ---------------------------------------------- Values before the ramp
     
    % Temperature
    subplot(3,4,1)
    plot(T(8,:)-273.15,Y_T(8,:).*1e-3,'-r')
    xlabel('Temperature (°C)'),ylabel('Depth (km)')
    
    title({'Before the ramp:'})
    
    % Radiogenic Heat production
    subplot(3,4,2)
    plot(H_rad(8,:).*rho_c,Y_T(8,:).*1e-3,'-r')
    xlabel('Radiogenic Heat (W*m^-3)')

    % Viscosity
    subplot(3,4,3)
    semilogx(eta(8,:),Y_T(8,:).*1e-3,'-r')
    xlabel('Effective viscosity (Pa*s)')
    
    % Shear Heat production
    subplot(3,4,4)
    plot(H_shearheat(8,:),Y_T(8,2:end-1).*1e-3,'-r')
    xlabel('Shear Heat (W*m^-3)')

    % -------------------------------------------------- Values on the ramp
    
    % Temperature
    subplot(3,4,5)
    plot(T(14,:)-273.15,Y_T(14,:).*1e-3,'-r')
    xlabel('Temperature (°C)'),ylabel('Depth (km)')
    
    title({'On the ramp:'})
    
    % Radiogenic Heat production
    subplot(3,4,6)
    plot(H_rad(14,:).*rho_c,Y_T(14,:).*1e-3,'-r')
    xlabel('Radiogenic Heat (W*m^-3)')

    % Viscosity
    subplot(3,4,7)
    semilogx(eta(14,:),Y_T(14,:).*1e-3,'-r')
    xlabel('Effective viscosity (Pa*s)')
    
    % Shear Heat production
    subplot(3,4,8)
    plot(H_shearheat(14,:),Y_T(14,2:end-1).*1e-3,'-r')
    xlabel('Shear Heat (W*m^-3)')
    
    % ----------------------------------------------- Values after the ramp
    
    % Temperature
    subplot(3,4,9)
    plot(T(22,:)-273.15,Y_T(22,:).*1e-3,'-r')
    xlabel('Temperature (°C)'),ylabel('Depth (km)')
    
    title({'After the ramp:'})
    
    % Radiogenic Heat production
    subplot(3,4,10)
    plot(H_rad(22,:).*rho_c,Y_T(22,:).*1e-3,'-r')
    xlabel('Radiogenic Heat (W*m^-3)')

    % Viscosity
    subplot(3,4,11)
    semilogx(eta(22,:),Y_T(22,:).*1e-3,'-r')
    xlabel('Effective viscosity (Pa*s)')
    
    % Shear Heat production
    subplot(3,4,12)
    plot(H_shearheat(22,:),Y_T(22,2:end-1).*1e-3,'-r')
    xlabel('Shear Heat (W*m^-3)')
    
    % ---------------------------------------------------------------------
    
%     set(gcf,'paperunits','normalized','position',[745 291.4000 560 420.0000])
    set(gcf,'paperunits','normalized','position',[805 189.8000 712.8000 546.4000])
    
    drawnow

end